/*
 * Decompiled with CFR 0.152.
 */
package mezz.modnametooltip;

import java.util.List;
import java.util.Optional;
import mezz.modnametooltip.Config;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.lang3.StringUtils;

public class TooltipEventHandler {
    private final Config config;

    public TooltipEventHandler(Config config) {
        this.config = config;
    }

    public void onToolTip(ItemTooltipEvent event) {
        String modNameFormat = this.config.getModNameFormat();
        if (modNameFormat.isEmpty()) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        TooltipEventHandler.getModName(itemStack).ifPresent(modName -> {
            List toolTip = event.getToolTip();
            if (!TooltipEventHandler.isModNameAlreadyPresent(toolTip, modName)) {
                toolTip.add(Component.m_237113_((String)(modNameFormat + modName)));
            }
        });
    }

    private static Optional<String> getModName(ItemStack itemStack) {
        return TooltipEventHandler.getCreatorModId(itemStack).map(TooltipEventHandler::getModName);
    }

    private static Optional<String> getCreatorModId(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return Optional.empty();
        }
        Item item = itemStack.m_41720_();
        String creatorModId = item.getCreatorModId(itemStack);
        return Optional.ofNullable(creatorModId);
    }

    private static String getModName(String modId) {
        ModList modList = ModList.get();
        return modList.getModContainerById(modId).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElseGet(() -> StringUtils.capitalize((String)modId));
    }

    private static boolean isModNameAlreadyPresent(List<Component> tooltip, String modName) {
        if (tooltip.size() > 1) {
            Component line = tooltip.get(tooltip.size() - 1);
            String lineString = line.getString();
            String withoutFormatting = ChatFormatting.m_126649_((String)lineString);
            return modName.equals(withoutFormatting);
        }
        return false;
    }
}

